define([
    'underscore',
    'backbone',
    'Layout',
    'modules/page/content/single-column-layout-view',
],
function(_, Backbone, Layout, SingleColumnLayoutView) {
    'use strict';

    describe('Single Column Layout View', function() {
        var view;
        var $view;
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            spyOn(SingleColumnLayoutView.prototype, 'routeToPrevious').and.callThrough();
            spyOn(Backbone.history, 'navigate');


            view = new SingleColumnLayoutView({
                template: _.template('<%= primaryHeader({ heading: "Single Column", options: {leftBtn: {id: "back-btn", icon: "ui-icon-carat-l", style: "tablet-hidden ui-btn-icon-notext", title: "Return to Requests/Appointments"}} }) %>'),
                previousRoute: 'appointments',
            });

            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('has templateHelper primaryHeader', function() {
            expect(typeof view.templateContext.primaryHeader).toEqual('function');
        });

        it('has routeToPrevious as event handler for a back button', function() {
            $view.find('#back-btn').click();
            expect(view.routeToPrevious).toHaveBeenCalled();
            expect(Backbone.history.navigate).toHaveBeenCalledWith('appointments', {trigger: true});
        });
    });
});
